﻿using log4net;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Threading.Tasks;
using VA.PPMS.IWS.Api.Configuration.Interface;
using VA.PPMS.IWS.Api.Data;
using VA.PPMS.IWS.Api.Helpers;
using VA.PPMS.IWS.Api.HttpClientHandler.Interface;

namespace VA.PPMS.IWS.Api.Controllers
{
    [Route("[controller]/v1")]
    public class CcnInitialDocRefController : Controller
    {
        private readonly ILog _logger;
        private readonly IIwsConfiguration _configuration;
        private readonly IHttpClientHandler _client;

        public CcnInitialDocRefController(ILog logger, IIwsConfiguration configuration, IHttpClientHandler client)
        {
            _logger = logger;
            _configuration = configuration;
            _client = client;
        }

        [HttpPost]
        public async Task<IActionResult> Post([FromBody] string fhirMessage)
        {
            try
            {
                _logger.Info("@@@@@ Info - Start POST for CcnInitialDocRefController @@@@@");

                var message = DasHelper.ParseHeaders(Request);

                var fhirObject = new FhirMessage();
                await fhirObject.LoadFhirMessage(fhirMessage);

                _logger.Info("@@@@@ Info - FHIR Message loaded @@@@@");

                if (!fhirObject.IsValid)
                {
                    _logger.Error("DocumentReference payload is invalid in CcnInitialDocRefController");
                    return StatusCode(StatusCodes.Status500InternalServerError, "DocumentReference payload is invalid");
                }

                _logger.Info($"CcnInitialDocRefController Process DocumentReference data {fhirObject.Id}");

                var url = fhirObject.ExtractUrl();
                if (!string.IsNullOrEmpty(url) && message.IsValid)
                {
                    message.Content = url;

                    _logger.Info($"@@@@@ Info - Content is {url} @@@@@");

                    using (var response = await _client.PostAsync(await _configuration.GetCcnInitialDocRefUri(), message))
                    {
                        if (response.IsSuccessStatusCode)
                        {
                            _logger.Info("@@@@@ Info - End POST for CcnInitialDocRefController @@@@@");
                            return StatusCode(StatusCodes.Status201Created, "Successfully processed.");
                        }

                        _logger.Error($"CcnInitialDocRefController POST Exception. There was an error posting to the Function API: {response}");
                        var error = await response.Content.ReadAsStringAsync();
                        _logger.Error($"CcnInitialDocRefController POST Exception. The error is {error}: {response}");

                        return StatusCode(StatusCodes.Status500InternalServerError, "CcnInitialDocRefController POST Exception");
                    }
                }

                _logger.Error("CcnInitialDocRefController: Bundle is missing data required to process the transaction");
                return StatusCode(StatusCodes.Status500InternalServerError, "Bundle is missing data required to process the transaction");
            }
            catch (Exception ex)
            {
                _logger.Error("CcnInitialDocRefController POST Exception:", ex);
                return StatusCode(StatusCodes.Status500InternalServerError, ex.Message);
            }
        }
    }
}